/* --------------------------------------------------------------
 job_configuration.js 2018-08-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2018 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * TODO: Change URL for Ajax calls when endpoint is ready
 */
gx.controllers.module(
    // ------------------------------------------------------------------------
    // CONTROLLER NAME
    // ------------------------------------------------------------------------
    'job_configuration',

    // ------------------------------------------------------------------------
    // CONTROLLER LIBRARIES
    // ------------------------------------------------------------------------
    [
        'xhr',
        'modal',
        `${gx.source}/libs/info_box`
    ],

    // ------------------------------------------------------------------------
    // CONTROLLER BUSINESS LOGIC
    // ------------------------------------------------------------------------
    function (data) {
        'use strict';

        // ------------------------------------------------------------------------
        // VARIABLES
        // ------------------------------------------------------------------------

        /**
         * Controller reference.
         *
         * @type {jQuery}
         */
        const $this = $(this);

        /**
         * Default options for controller,
         *
         * @type {object}
         */
        const defaults = {};

        /**
         * Final controller options.
         *
         * @type {object}
         */
        const options = $.extend(true, {}, defaults, data);

        /**
         * Module object.
         *
         * @type {{}}
         */
        const module = {};

        const $btnOpenConfig = $('.open-configuration');

        const $modal = $('.modal.configuration');

        const $modalBody = $modal.find('.modal-body');

        // ------------------------------------------------------------------------
        // PRIVATE METHODS
        // ------------------------------------------------------------------------

        /**
         * Get configuration elements for specific task
         *
         * @param task
         * @private
         */
        const _getConfigurationContent = function (task) {
            // Perform request.
            $.ajax({
                url: 'admin.php?do=CronjobAjax/getConfiguration&task=' + task
            }).done(
                function (response) {
                    return response;
                }
            ).fail(
                function () {
                    return 'No configuration found';
                }
            );
        }

        /**
         * Triggers Ajax call to save new configuration values
         *
         * @param task
         * @param data
         * @private
         */
        const _saveConfiguration = function (task, data) {
            // AJAX request options.
            const requestOptions = {
                type: 'POST',
                data: {data},
                url: 'admin.php?do=CronjobAjax/saveConfiguration&task=' + task
            };

            const $modal = $('.modal.configuration');

            // Perform request.
            $.ajax(requestOptions)
                .done(response => _handleSaveRequestResponse(response))
                .always(() => $modal.modal('hide'));
        }

        /**
         * Shows success message if save was successful otherwise an error will be displayed
         *
         * @param response
         * @private
         */
        const _handleSaveRequestResponse = function (response) {
            // Error message phrases.
            const errorTitle = jse.core.lang.translate('save_configuration_error_title', 'cronjobs');
            const errorMessage = jse.core.lang.translate('save_configuration_error_text', 'cronjobs');

            // Check for action success.
            if (response.includes('success')) {
                // Add success message to admin info box.
                jse.libs.info_box.addSuccessMessage();
            } else {
                // Show error message modal.
                jse.libs.modal.showMessage(errorTitle, errorMessage);
            }
        }


        const _showCronjobConfiguration = response => {

            $modalBody.empty();

            $modalBody.attr('data-gx-widget', 'switcher')

            const $form = $('<form/>', {
                'class': 'form-horizontal'
            });
            $form.appendTo($modalBody);

            const configuration = response.configuration;

            for (let i = 0; i < configuration.length; i++) {

                const fieldset = _renderFieldset(jse.core.lang.translate(configuration[i].title, response.language_section));

                for (let test in configuration[i].fields) {
                    if (!configuration[i].fields.hasOwnProperty(test)) {
                        continue
                    }

                    const configField = configuration[i].fields[test];
                    const $input = $('<input/>', {
                        'type': configField.type,
                        'id': configField.name,
                        'name': configField.name,
                        'class': 'form-control',
                        'value': undefined !== configField.value ? configField.value : configField.defaultValue
                    });

                    if (configuration[i].fields[test].type === 'hidden') {
                        $form.prepend($input);
                        continue;
                    }

                    if (configField.type === 'select') {
                        const $select = $('<select/>', {
                            'class': 'form-control'
                        });

                        for (let k = 0; k < configField.values.length; k++) {
                            $select.append($('<option/>', {
                                'value': configField.values[k].value,
                                'text': jse.core.lang.translate(configField.values[k].text, response.language_section)
                            }));
                        }
                        const $formGroup = _renderFormGroup(configField.label, response.language_section, $select);
                        fieldset.append($formGroup);

                    } else {
                        const $formGroup = _renderFormGroup(configField.label, response.language_section, $input);
                        fieldset.append($formGroup);
                    }
                }

                $form.append(fieldset);
            }

            gx.widgets.init($modalBody);
            $modal.modal('show');
        };

        const _renderFieldset = (legendTitle) => {
            const $fieldset = $('<fieldset/>');
            const $legend = $('<legend/>', {'text': legendTitle});

            return $fieldset.append($legend);
        }

        const _renderFormGroup = (label, section, $inputHtml) => {
            const $formGroup = $('<div/>', {
                'class': 'form-group'
            });
            const $label = $('<label/>', {
                'class': 'col-sm-3 control-label',
                'for': 'active',
                'text': jse.core.lang.translate(label, section)
            });
            const $container = $('<div/>', {
                'class': 'col-sm-9'
            });

            $container.append($inputHtml)
            return $formGroup.append($label).append($container);
        };

        // ------------------------------------------------------------------------
        // INITIALIZATION
        // ------------------------------------------------------------------------
        module.init = done => {
            $btnOpenConfig.on('click', function (event) {
                const task = $(this).closest('.cronjob-element').attr('data-task');

                event.preventDefault();

                jse.libs.xhr.get({
                    url: './admin.php?do=CronjobAjax/getConfiguration&task=' + task
                }).done(_showCronjobConfiguration).fail(r => console.error(r));

                // let confData = _getConfigurationContent(task);
                //
                // $('.configuration.modal .modal-body').html(confData);
                //
                // $modal.attr('data-task', task);
                // $modal.modal('show');
            })

            $('.modal.configuration button[type="submit"]').on('click', function (event) {
                event.preventDefault();

                let formData = $(this).serializeArray();
                let task = $('.modal.configuration').attr('data-task');

                _saveConfiguration(task, formData);
            });

            $('.modal.configuration').on('hide.bs.modal', function () {
                $('.modal.configuration').removeAttr('data-task');
            })

            done();
        }

        return module;
    }
);